/*
 * ffproxy (c) 2002, 2003 Niklas Olmes <niklas@noxa.de>
 *                                     <niklas.olmes@web.de>
 * http://faith.eu.org
 * 
 * $Id: dns.c,v 1.6 2003/07/20 10:38:23 niklas Exp $
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 675
 * Mass Ave, Cambridge, MA 02139, USA.
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include <stdio.h>
#include <string.h>
#include <netdb.h>
#include <resolv.h>

#include "req.h"
#include "alloc.h"
#include "dns.h"

unsigned long
resolve(const char *h)
{
	struct hostent *hp;
	unsigned long   ip;

	if ((ip = inet_addr(h)) != INADDR_NONE)
		return ip;

	if ((hp = gethostbyname(h)) == NULL)
		return INADDR_NONE;
	else {
		(void) memcpy(&ip, hp->h_addr, hp->h_length);
		return ip;
	}
}

char           *
ip_to_a(int ip)
{
	char           *p;
	struct in_addr  addr;

	addr.s_addr = ip;
	p = inet_ntoa(addr);

	return p;
}

char           *
resolve_to_a(const char *h)
{
	char           *p;

	p = ip_to_a(resolve(h));

	return p;
}

struct clinfo  *
identify(const struct sockaddr_in * addr)
{
	struct clinfo  *host;
	struct hostent *hp;
	struct in_addr  ip;

	host = (struct clinfo *) my_alloc(sizeof(struct clinfo));
	(void) memset(host, 0, sizeof(struct clinfo));

	(void) strncpy(host->ip, inet_ntoa(addr->sin_addr), sizeof(host->ip) - 1);
	host->ip[sizeof(host->ip) - 1] = '\0';

	if ((hp = gethostbyaddr((char *) &addr->sin_addr, sizeof(addr->sin_addr), AF_INET)) != NULL) {
		(void) strncpy(host->name, hp->h_name, sizeof(host->name) - 1);
		host->name[sizeof(host->name) - 1] = '\0';
	} else
		*host->name = '\0';

	if ((hp = gethostbyname(host->name)) != NULL) {
		(void) memcpy(&ip.s_addr, hp->h_addr, hp->h_length);
		(void) strncpy(host->rip, inet_ntoa(ip), sizeof(host->rip) - 1);
		host->rip[sizeof(host->rip) - 1] = '\0';
	} else
		*host->rip = '\0';

	return host;
}
