/*
 * ffproxy (c) 2002, 2003 Niklas Olmes <niklas@noxa.de>
 *                                     <niklas.olmes@web.de>
 * http://faith.eu.org
 * 
 * $Id: socket.c,v 1.41 2003/08/01 20:11:05 niklas Exp niklas $
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 675
 * Mass Ave, Cambridge, MA 02139, USA.
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#ifdef LINUX
	#include <endian.h>
#else
	#include <machine/endian.h>
#endif

#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "req.h"
#include "cfg.h"
#include "print.h"
#include "request.h"
#include "dns.h"
#include "access.h"
#include "socket.h"

void
open_socket(void)
{
	extern struct cfg config;
	struct sockaddr_in addr, claddr;
	struct clinfo  *clinfo;
	socklen_t       claddr_len;
	pid_t           pid;
	void           *foo;
	int             s, cl;

	if ((s = socket(AF_INET, SOCK_STREAM, 0)) == -1)
		fatal("socket() failed");

	if (setsockopt(s, SOL_SOCKET, SO_REUSEADDR, &foo, sizeof(foo)) != 0)
		fatal("setsockopt() failed");

	(void) memset(&addr, 0, sizeof(addr));
	addr.sin_family = AF_INET;
	addr.sin_addr.s_addr = config.ip ? config.ip : htonl(INADDR_ANY);
	addr.sin_port = config.port ? htons(config.port) : htons(8080);

	if (bind(s, (struct sockaddr *) & addr, sizeof(addr)) != 0)
		fatal("bind() failed");

	if (listen(s, config.backlog) != 0)
		fatal("listen() failed");

	info("ready, waiting for requests on IP %s port %d", config.ip ? ip_to_a(config.ip) : "(any)", config.port ? config.port : 8080);

	claddr_len = sizeof(claddr);
	config.ccount = 0;

	for (;;) {
		if (config.ccount >= config.childs) {
			usleep(50000);
			continue;
		}
		if ((cl = accept(s, (struct sockaddr *) & claddr, &claddr_len)) == -1) {
			debug("open_socket() => accept() failed");
			continue;
		}
		debug("open_socket() => connection, checking access");
		clinfo = identify(&claddr);
		if (check_access(clinfo) != 0) {
			debug("open_socket() => no access");
			if (config.logrequests)
				info("connection attempt from %s [%s]/[%s], ACCESS DENIED", clinfo->name, clinfo->ip, clinfo->rip);
			free(clinfo);
			(void) close(cl);
			continue;
		}
		if (config.logrequests)
			info("connection attempt from %s [%s]/[%s], access granted", clinfo->name, clinfo->ip, clinfo->rip);

		if ((pid = fork()) == -1) {
			debug("open_socket() => fork() failed");
			free(clinfo);
			(void) close(cl);
			continue;
		} else if (pid == 0) {
			(void) close(s);
			setup_log_slave();
			handle_request(cl, clinfo);
			free(clinfo);
			(void) close(cl);
			exit(0);
		} else {
			free(clinfo);
			config.ccount++;
			(void) close(cl);
		}
	}

	/* NOTREACHED */
}
