/*
 * ffproxy (c) 2002, 2003 Niklas Olmes <niklas@noxa.de>
 *                                     <niklas.olmes@web.de>
 * http://faith.eu.org
 * 
 * $Id: time.c,v 1.4 2003/07/20 10:38:23 niklas Exp $
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 675
 * Mass Ave, Cambridge, MA 02139, USA.
 */

#include <sys/types.h>

#include <stdio.h>
#include <utime.h>
#include <time.h>

#include "req.h"
#include "print.h"
#include "time.h"

static time_t   my_mktime(struct tm *);

int
timestamp(struct req * r)
{
	struct utimbuf  time;

	debug("timestamp() => string is (%s)", r->tstamp);
	if ((time.actime = time.modtime = my_convtime(r->tstamp)) != -1) {
		debug("timestamp() => stamping file (%s) (%d)", r->fname, time.actime);
		(void) utime(r->fname, &time);
		return 0;
	}
	return -1;
}

time_t
my_convtime(const char *tstamp)
{
	struct tm       t;
	time_t          tm;

	t.tm_isdst = 0;

	if (strptime(tstamp, "%a, %d %b %Y %T", &t) != NULL) {
		if ((tm = my_mktime(&t)) == -1)
			return -1;
		else
			return tm;
	}
	return -1;
}

static          time_t
my_mktime(struct tm * t)
{
	time_t          tl, tb;

	tl = mktime(t);
	tb = mktime(gmtime(&tl));

	return (tl <= tb ? (tl + (tl - tb)) : (tl - (tb - tl)));
}
